require( "scripts/style.lua" );

require( "scripts/basicSetting.lua");

guestCreationDelay = 34000;
guestCreationSpeedIncrease = 2000;
minGuestsToCreate = 3;
maxGuestsToCreate = 4;

useWineTable = 1;
numMoodBoosts = 3;


levelSetting1 = 
{	
	-- total of 100%
	guestListPercentage = 
	{
		female01Percent=10,
		female02Percent=15,
		female03Percent=10,
		female04Percent=10,
		male01Percent=10,
		male02Percent=15,
		male03Percent=0,
		male04Percent=10,
		unclePercent=10,
		auntPercent=10
	},
	
	guestAttributes = 
	{
	-- low to high range
	-- percentage from 0 to 100
		tolerance =		{50000, 60000},
		waitBeforeSit =		{1000, 1000},
		waitBeforeAppetizer =	{1000, 1000},
		waitBeforeDinner =	{8000, 8000},
		waitBeforeCake =	{12000, 12000},
		waitBeforeGift =	{1000, 1000},
		percentRequestDrink =	{0, 10},
		percentRequestMusic =	{0, 0},
		percentRequestResit =	{0, 0},
		percentRequestCoffee =	{10, 50},
		percentRequestTissue =	{10, 50}
	}
}




dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();
LManager:SetLevelNumber(3,1);

LManager:AddNewTable( 1, 6, 230, 360, "assets/images/table/redtable_6", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 2, 3, 260, 230, "assets/images/table/bluetable", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 3, 3, 260, 485, "assets/images/table/bluetable", "assets/images/food/item_mark3", "B" );

LManager:SetLevelSetting ("dogDelay", 200000);
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 400000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 300000);
LManager:SetLevelSetting ("speakerChance", 60);

LManager:SetLevelSetting ("blaster", 1);

-- Testing...
LManager:SetLevelSetting( "guestLeaveAllow", 5 );

gameObject = LManager:GenerateGameObject();

levelSetting = LManager:GenerateLevelSettings();
levelSetting.mode = "endless";
levelSetting.passScore = 
	{
	    600 -- the base score. for each level the passScore is baseScore + baseScore*level*level
	};
	
--dofile( "scripts/LevelDialogGenerator.lua" );

LManager:SetChairImage("assets/images/table/chair03");

MakeDialog
{

	Bitmap
	{
		name="backgroundimage",
		image="images/bg_cruise",
				
		GameWindow
		{ 	
			x = 0, y = 0, w = kMax, h = kMax,
			Button{
			x=800, y=600, --set offscreen
			--x=140,
			--y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="upgrade",
			label="upgradetitle",
			type = kPush,
			command = 
				function()
				    OpenArcadeUpgrade();
				end
				
			};			
		},
		-- the pause button
		Button{
			x=10,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="pause",
			label="ui.dialog.pause.title",
			type = kPush,
			command = 
				function()
				    DoPause();
				end
				
		};
	},
	
}
